<?php if (!defined('FLUX_ROOT')) exit;
if($config['display_countdown']) {
  $st = new DateTime($config['server_start_time'], new DateTimeZone($config['timezone']));
  $nw = new DateTime('now', new DateTimeZone($config['timezone']));
  // $nw->setTimezone(new DateTimeZone($config['timezone']));
  $df = $st->diff($nw, false);
  $df2 = $st->gettimestamp() - $nw->gettimestamp();

  //echo "<pre>";
  //var_dump($nw);
  //var_dump($st);
  //die();
}
?>
  <!-- Section: About ------------------------------------------------->
  <section id="about-section">
    <div class="container">
      <div class="row justify-content-between">
        <div class="render-container col-12 col-lg-3 d-none d-lg-flex">
          <div class="render-box t-lg-70 l-lg-30">
            <picture >
              <source srcset="<?php echo $this->themePath('includes/img/renders/render-priest.webp')?>" type="image/webp">
              <img src="<?php echo $this->themePath('includes/img/renders/render-priest.png')?>" alt="" data-aos="zoom-in-right"/>
            </picture>
          </div>
        </div>
        <div class="section-content col-12 col-lg-5">
          <div class="section-title">
            <h2 class="title" data-aos="fade-down-right" data-aos-delay="100">RAGNA<span class="heading-accent">REALMS</span></h2>
          </div>
          <p data-aos="fade-right" data-aos-delay="200">
            <?php echo $config['about_text'] ?>
          </p>
          <?php if($config['display_countdown']):?>
            <?php if($df2 <= -1): ?>
            <div class="text-center">
              <h4 class="mb-0">Server Started</h4>
              <h2><span class="heading-accent">Play Now!</span></h2>
            </div>
            <?php else:?>
            <h3 class="h4 mt-4" data-aos="zoom-in" data-aos-delay="300">Server Launch</h3>
            <div id="timer-box">
              <div id="timer-clock">
                <div id="timer-days" class="timer-box">
                  <div class="timer-val"><?php echo str_pad($df->days, 2, "0", STR_PAD_LEFT)?></div>
                  <div class="timer-sub">Days</div>
                </div>
                <div id="timer-hours" class="timer-box">
                  <div class="timer-val"><?php echo str_pad($df->h, 2, "0", STR_PAD_LEFT)?></div>
                  <div class="timer-sub">Hours</div>
                </div>
                <div id="timer-minutes" class="timer-box">
                  <div class="timer-val"><?php echo str_pad($df->i, 2, "0", STR_PAD_LEFT)?></div>
                  <div class="timer-sub">Minutes</div>
                </div>
                <div id="timer-seconds" class="timer-box">
                  <div class="timer-val"><?php echo str_pad($df->s, 2, "0")?></div>
                  <div class="timer-sub">Seconds</div>
                </div>
              </div>
            </div>
            <?php endif?>
          <?php endif?>
          <h3 class="h4 mt-4" data-aos="zoom-in" data-aos-delay="300">Server Information</h3>
          <table class="table table-borderless table-sm" data-aos="zoom-out" data-aos-delay="400">
            <tr>
              <th scope="row" class="text-end">Server Episode:</th>
              <td>13.2 pre-renewalish</td>
              <th scope="row" class="text-end">MvP Drop:</th>
              <td>&times;10000</td>
            </tr>
            <tr>
              <th scope="row" class="text-end">Base EXP:</th>
              <td>&times; 8000</td>
              <th scope="row" class="text-end">Max ASPD:</th>
              <td>195</td>
            </tr>
            <tr>
              <th scope="row" class="text-end">Job EXP:</th>
              <td>&times; 8000</td>
              <th scope="row" class="text-end">MVP & Mini Boss:</th>
              <td class="text-danger">x300</td>
            </tr>
            <tr>
              <th scope="row" class="text-end">Card Drop:</th>
              <td>&times; 1000</td>
              <th scope="row" class="text-end">Dual Client:</th>
              <td class="text-success">ENABLED</td>
            </tr>
            <tr>
              <th scope="row" class="text-end">Normal Drop:</th>
              <td>&times; 3000</td>
              <th scope="row" class="text-center text-success" colspan="2">Gepard 3.0 Protected</th>
            </tr>
          </table>
          <?php if(!empty($config['streamer_btn_link']) && !empty($config['streamer_btn_title'])):?>
          <div id="about-btn" data-aos="zoom-in" data-aos-delay="100" class="gap-2 d-block">
            <a href="<?php echo $config['facebook_btn_link']?>" class="btn btn-yellow btn-facebook btn-center" target="_self"><i class="fa-brands fa-facebook"></i>Facebook</a>
            <a href="<?php echo $config['discord_btn_link']?>" class="btn btn-yellow btn-discord btn-center" target="_self"><i class="fa-brands fa-discord"></i>Discord</a>
          </div>
          <?php endif;?>
        </div>
        <div class="render-container col-12 col-lg-4">
          <!--<div class="render-box t-lg-50">
            <picture>
              <source srcset="<?php echo $this->themePath('includes/img/renders/render-naght.webp')?>" type="image/webp">
              <img src="<?php echo $this->themePath('includes/img/renders/render-naght.png')?>" alt="" data-aos="zoom-in-right"/>
            </picture>
          </div>-->
          <widgetbot
            server="<?php echo $config['wiget_discord_id']?>"
            channel="<?php echo $config['wiget_discord_channel']?>"
            width="600"
            height="600"
          ></widgetbot>
          <script src="https://cdn.jsdelivr.net/npm/@widgetbot/html-embed"></script>
        </div>
      </div>
    </div>


    <?php if($config['display_countdown']):?>
    <script type="text/javascript">
      $(function() {
        if($('#timer-box').length > 0) {
          // Set the date we're counting down to
          var countDownDate = new Date('<?php echo $st->format('Y-m-d H:i:s'); ?>').getTime();

          // Update the count down every 1 second
          var x = setInterval(function() {

            // Get today's date and time
            d = new Date();
            localtime = d.getTime();
            localoffset = d.getTimezoneOffset() * 60000;

            // UTC
            utc = localtime + localoffset;

            var now = new Date(utc + 60000 * (8 * 60)); /* GMT+8 */
            console.log(now)
            var distance = 0;
            if(now > countDownDate) {
              $('#timer-title').html('Server Started!')
              distance = now - countDownDate;
            } else {
              // Find the distance between now and the count down date
              distance = countDownDate - now;
            }

            // Time calculations for days, hours, minutes and seconds
            var days = Math.floor(distance / (1000 * 60 * 60 * 24));
            var hours = Math.floor((distance % (1000 * 60 * 60 * 24)) / (1000 * 60 * 60));
            // hours += days * 24;
            var minutes = Math.floor((distance % (1000 * 60 * 60)) / (1000 * 60));
            var seconds = Math.floor((distance % (1000 * 60)) / 1000);

            // console.log('seconds', seconds, $('.timer-seconds .ctime'))

            // Display the result
            $('#timer-box #timer-days .timer-val').text(pad(days,2));
            $('#timer-box #timer-hours .timer-val').text(pad(hours,2));
            $('#timer-box #timer-minutes .timer-val').text(pad(minutes,2));
            $('#timer-box #timer-seconds .timer-val').text(pad(seconds,2));

            // If the count down is finished, write some text
            if (distance < 0) {
              clearInterval(x);
              $('#timer-box #timer-days .timer-val').text(pad(days,2));
              $('#timer-box #timer-hours .timer-val').text(pad(hours,2));
              $('#timer-box #timer-minutes .timer-val').text(pad(minutes,2));
              $('#timer-box #timer-seconds .timer-val').text(pad(seconds,2));
            }
          }, 1000);
        }
      });
    </script>
    <?php endif?>
  </section>
