<?php if (!defined('FLUX_ROOT')) exit;


# ==========================================================================================================
# [HTML Meta data]
# ==========================================================================================================
# This part handles the info for search engine. For example, it will display the additional infomation when you share your
# FluxCP links via Discord. This option is optional and thus there is no need to define this if you are not sure.
# However, we still provide you with a simple example.
$config['meta_desc'] = "ragnarealms is a fun private Ragnarok Online server that focuses on balance between the grind and the rate. ";

# this settings will display the image when sharing via Discord
# recommended size: 1200 x 630 pixels
$config['meta_image'] = $this->themePath('includes/img/cover_realms.png');

# ==========================================================================================================
# [ragnarealm Preloader Animation]
# ==========================================================================================================
# the template may take some time to load and during this process, some parts might displayed in the wrong
# positions. And thus makes the template looks a bit weird. To prevent this disjointed feeling, the template
# also comes with a preloader animation. Which you can disable in the option below.
$config['enable_preloader_animation'] = true;

# ==========================================================================================================
# [ragnarealm Navigations]
# ==========================================================================================================
# Top navigation bar in this template displays the navigations that you have defined in the flux
# configuration settings in
#
#       config/application.php
#
$config['main_account'] = array(
    array(
        'title' => '<i class="fa-solid fa-user-gear fa-sm"></i> My Account',
        'link'  => $this->url('account','view'),
    ),
    //array(
    //    'title' => '<i class="fa-brands fa-discord fa-sm"></i> Discord',
    //    'link'  => 'https://www.discord.com',
    //),
    array(
        'title' => '<i class="fa-solid fa-lock fa-sm"></i> Change Password',
        'link'  => $this->url('account', 'changepass'),
    ),
    array(
        'title' => '<i class="fa-solid fa-right-from-bracket fa-sm"></i> Logout',
        'link'  => $this->url('account','logout'),
    ),
);

# ==========================================================================================================
# [ragnarealm Main Section]
# ==========================================================================================================
# The main section or something we usually call it as splash section, are the top most part of the theme.
# This sections comes with 3 extra buttons and a login panel.
$config['splash_text'] = "Lorem ipsum dolor sit amet, consectetur adipiscing elit. Morbi placerat lorem ac nibh pharetra pretium. Donec in tellus erat. Ut vestibulum nisi eu nisi auctor ullamcorper. <br /><br />Sed rhoncus nulla massa, non sagittis tellus placerat id. Nulla eget mauris eu turpis malesuada vehicula. Suspendisse sem arcu, malesuada sit amet ante nec, vehicula hendrerit tortor. Aliquam vitae euismod nibh. Vestibulum vulputate a nulla in ullamcorper. Cras nec euismod augue. Proin suscipit risus quis quam vulputate, a finibus lectus laoreet. Sed vel nisl tempor, bibendum urna in, feugiat tortor. Phasellus laoreet sem a pellentesque lacinia. Integer et sem commodo, lobortis arcu id, maximus orci. Sed vel arcu ex. Ut at dui eros. Vestibulum condimentum pharetra porta.";
$config['play_video'] = "https://www.youtube.com/watch?v=v7fscGPL8Mk&t=21s";
$config['download_btn'] = "https://www.google.com";
$config['register_btn'] = "https://www.google.com";

# ==========================================================================================================
# [Count Down Timer]
# ==========================================================================================================
# Must use the format Y-m-d H:i:s
$config['display_countdown'] = true;
$config['server_start_time'] = "2023-12-16 18:00:00";
# set the timezone at $config['timezone'] below (use ctrl+f)


# ==========================================================================================================
# [ragnarealm News Section]
# ==========================================================================================================
# The following configurations are use to define the news to automatically fetch using RSS feed.
#
# This option is to disable the news sections
$config['enable_news_section'] = true;
#

# the 'category_name' defines the category title displayed in headings inside the "image"
# the 'category_img' defines the background image of that particular category
# the 'feed_url' defines the link of your RSS feed.
# The 'feed_type' defines what kind of RSS feed provided to the theme.
# For example, Invasion Power Board forum uses RSS. While, phpBB3 forum uses ATOM.
# You can test it on your feed links, if it doesn't show up, you can use the other type

$config['news_feed'] = array(
    array(
        'category_name'         => 'News',
        'feed_url'              => 'https://g329110.invisionservice.com/forum/2-ragnarealms-news.xml',
        'feed_type'             => 'rss',
    ),
    array(
        'category_name'         => 'Events',
        'feed_url'              => 'https://g329110.invisionservice.com/forum/8-ragnarealms-event.xml/?member=1&key=074404ced327fc7e2ee2affb085a7338',
        'feed_type'             => 'rss',
    ),
    array(
        'category_name'         => 'Patch Notes',
        'feed_url'              => 'https://g329110.invisionservice.com/forum/9-ragnarealms-update.xml/',
        'feed_type'             => 'rss',
    ),
);
# ============ IMPORTANT! ============
# This feed system uses caching system. If you deleted a news on the feed source, the news on the website will
# still be displayed normally. To ensure the news in website is displayed correctly, please also delete
# the files inside the cache folder.
#
#       fluxCP/themes/ragnarealm/includes/fcache/*

# ==========================================================================================================
# [About Section]
# ==========================================================================================================
# this option is to edit the text for the about section
$config['about_text'] = 'Welcome to Ragna Realms! A pre-renewalish 10.2 episode with a lot of features to offer. Storyline starts after reaching your max level, although we are a supre high-rate server, the grind will sure to entice all types of players! <a href="https://ragnarealms-ro.net/?module=main&action=downloads" target="_self">DOWNLOAD NOW.</a>';

$config['facebook_btn_link'] = "https://www.facebook.com/ragnarealms";
$config['discord_btn_link'] = "https://www.discord.gg/ragnarealms";

# ==========================================================================================================
# [Streamer (Support) Section]
# ==========================================================================================================
# The main text to attract people to the streamer section

# The text that describe the streamer section
$config['streamer_text'] = 'Playing Ragna Realms is 100% free; however, purchasing an item supports and helps us cover the costs of running a server. Purchasing items or donations help us pay the server and web hosting fees and also going towards any expansion and upgrades, advertising and other server expenses.';

# The button below the text
$config['streamer_btn_title'] = "Download Now";
$config['streamer_btn_link'] = $this->url('main', 'downloads'); 

# The twitch embed player autoplays on load (recommended: false).
# This is a problem with mobile user who use DATA plans. Their bandwidth quota usage will go down the drain quickly
# if left enabled
$config['streamer_autoplay'] = true;

# the twitch embed player is muted on load (recommended: true).
# No body likes the some random audio to pops out when you open a webpage
# If you really want to enable the autoplay, at least make the player muted.
$config['streamer_muted'] = false;

# Add as many streamer as you wish. it will display one at random
# Make sure its the streaming URL you copied from the address bar.
# both twitch and youtube are supported
$config['streamer_channel_name'] = array(
  'https://www.youtube.com/watch?v=cQWLMDflXo8&t=98s',
);


# ==========================================================================================================
# [Staff Section]
# ==========================================================================================================

# the 'name' defines the name of the staff
# the 'role' defines the role of the staff
# the 'img'  defines the char sprite of the staff
#            note: This can be generated using RMS's Char Simulator: https://ro-character-simulator.ratemyserver.net/

$config['staff'] = [
  [
    'name' => 'Fresh',
    'role' => 'Founder',
    'img' => $this->themePath('includes/img/staff/founder.png'),
  ],
  [
    'name' => 'Gelo',
    'role' => 'Web Designer',
    'img' => $this->themePath('includes/img/staff/Web-designer.png'),
  ],
  [
    'name' => 'Speedrun',
    'role' => 'Mapper',
    'img' => $this->themePath('includes/img/staff/speedrun.png'),
  ],
  [
    'name' => 'Kazuha',
    'role' => 'Developer1',
    'img' => $this->themePath('includes/img/staff/staff-1.png'),
  ],
  [
    'name' => 'Namor',
    'role' => 'Developer2',
    'img' => $this->themePath('includes/img/staff/staff-1.png'),
  ],
  [
    'name' => 'Lexus',
    'role' => 'Admin',
    'img' => $this->themePath('includes/img/staff/staff-1.png'),
  ],
  [
    'name' => 'Maja',
    'role' => 'Admin',
    'img' => $this->themePath('includes/img/staff/staff-1.png'),
  ],
  [
    'name' => 'Lorem',
    'role' => 'Ipsum',
    'img' => $this->themePath('includes/img/staff/staff-1.png'),
  ],
  [
    'name' => 'Lorem',
    'role' => 'Ipsum',
    'img' => $this->themePath('includes/img/staff/staff-1.png'),
  ],
  [
    'name' => 'Lorem',
    'role' => 'Ipsum',
    'img' => $this->themePath('includes/img/staff/staff-1.png'),
  ],
  [
    'name' => 'Lorem',
    'role' => 'Ipsum',
    'img' => $this->themePath('includes/img/staff/staff-1.png'),
  ],
];

# ==========================================================================================================
# [ragnarealm WoE Section]
# ==========================================================================================================
# This option is to disable the stats sections
$config['enable_woe_section'] = true;

# Find your timezone in here: https://www.php.net/manual/en/timezones.php
$config['timezone'] = 'Asia/Manila';

# the woe schedules
# this option does not affects or use the one displayed in the FluxCP's WoE page:
#
#       flux/?module=woe
#
# this option is only use in the front page to display the WoE status
#
$config['woe_schedule'] = array(
    array(
        'castle_id' => array(0,1,6,7,11,12,29),         // please refer to config/castlenames.php
        'woe_start' => 'Wednesday 21:00:00',
        'woe_end'   => 'Wednesday 22:00:00',
        'link'      => 'https://www.google.com'         // leave empty to disable link
    ),
    array(
        'castle_id' => array(5,2,3,13,14,18,19,24,26),  // please refer to config/castlenames.php
        'woe_start' => 'Saturday 09:00:00',
        'woe_end'   => 'Saturday 10:00:00',
        'link'      => ''                               // leave empty to disable link
    ),
    array(
        'castle_id' => array(10,15,16,17,8,9,4,31,25),  // please refer to config/castlenames.php
        'woe_start' => 'Sunday 22:00:00',
        'woe_end'   => 'Sunday 23:00:00',
        'link'      => ''                               // leave empty to disable link
    ),
);

# this option does not involve any calculation. it only display as text in the woe section.
$config['koe_schedule'] = '07:00 / 14:00 / 21:00';


# ==========================================================================================================
# [Ranker Sections]
# ==========================================================================================================
# these options controls the GoTM.
# as for now this is done manually.

# guild ID is required for the emblem
$gotm['guild_id'] = 0;
$gotm['emblem_len'] = ''; # put any value for emblem_len if the guild have any emblem

# the name of the guild
$gotm['guild_name'] = "Unknown Guild";

# the guild master's name
$gotm['guild_master'] = "n/a";

# how much points the guild has
$gotm['guild_points'] = 0;

# Castle Owners
# list the castle ids, based on application/castlenames.php
# ids that are not listed (commented) will not be shown on page
$config['open_castles'] = [
     0 => 'Al de Baran<br >Neuschwanstein',
     1 => 'Al de Baran<br >Hohenschwangau',
     2 => 'Al de Baran<br >Nuenberg',
     3 => 'Al de Baran<br >Wuerzburg',
     4 => 'Al de Baran<br >Rothenburg',

    // 5 => 'Geffen<br >Repherion',
    // 6 => 'Geffen<br >Eeyolbriggar',
    // 7 => 'Geffen<br >Yesnelph',
    // 8 => 'Geffen<br >Bergel',
    // 9 => 'Geffen<br >Mersetzdeitz',

    10 => 'Payon<br >Bright Arbor',
    11 => 'Payon<br >Scarlet Palace',
    12 => 'Payon<br >Holy Shadow',
    13 => 'Payon<br >Sacred Altar',
    14 => 'Payon<br >Bamboo Grove Hill',

    15 => 'Prontera<br >Kriemhild',
    16 => 'Prontera<br >Swanhild',
    17 => 'Prontera<br >Fadhgridh',
    18 => 'Prontera<br >Skoegul',
    19 => 'Prontera<br >Gondul',

    // 20 => 'Novice Aldebaran',
    // 21 => 'Novice Geffen',
    // 22 => 'Novice Payon',
    // 23 => 'Novice Prontera',

    24 => 'Schwaltzvalt<br >Himinn',
    25 => 'Schwaltzvalt<br >Andlangr',
    26 => 'Schwaltzvalt<br >Viblainn',
    27 => 'Schwaltzvalt<br >Hljod',
    28 => 'Schwaltzvalt<br >Skidbladnir',

    // 29 => 'Arunafeltz<br >Mardol',
    // 30 => 'Arunafeltz<br >Cyr',
    // 31 => 'Arunafeltz<br >Horn',
    // 32 => 'Arunafeltz<br >Gefn',
    // 33 => 'Arunafeltz<br >Bandis'
];

# -- clash arena rankings --
# this data are obtained automatically using pvpladder table
# the npc script are included with the theme package

# -- battleground rankings --
# as requested, the bg data are set using "manual" option below
$bg = [
  [
    'rank' => 1,
    'char_id' => 1,
    'name' => 'Lorem',
    'level' => 99
  ],
  [
    'rank' => 2,
    'char_id' => 2,
    'name' => 'Ipsum',
    'level' => 98
  ],
  [
    'rank' => 3,
    'char_id' => 3,
    'name' => 'Dolor',
    'level' => 97
  ],
  [
    'rank' => 4,
    'char_id' => 4,
    'name' => 'Ipsum',
    'level' => 96
  ],
  [
    'rank' => 5,
    'char_id' => 5,
    'name' => 'Ismet',
    'level' => 94
  ],
];
# ==========================================================================================================
# [ragnarealm Gallery Sections]
# ==========================================================================================================
# This option is to disable the stats sections
$config['enable_gallery_section'] = true;
#
# This option defines the gallery details.
# Note1: Only 4 items are allowed.
# Note2: Leave the link part empty to disable the link
$config['gallery_details'] = array(
    array(
        'title' => 'Valkyrja, The Land of ragnarealm',
        'link' => 'https://www.ragnarealm-ro.net/main',
        'desc' => 'Lorem ipsum dolor sit amet, consectetur adipiscing elit. Morbi placerat lorem ac nibh pharetra pretium. Donec in tellus erat. Ut vestibulum nisi eu nisi auctor ullamcorper.',
        'img' => $this->themePath('includes/img/gallery/gallery-1.jpg')
    ),
    array(
        'title' => 'World Boss Guards',
        'link' => '',       # leave empty to disable link
        'desc' => 'Lorem ipsum dolor sit amet, consectetur adipiscing elit. Morbi placerat lorem ac nibh pharetra pretium. Donec in tellus erat. Ut vestibulum nisi eu nisi auctor ullamcorper.',
        'img' => $this->themePath('includes/img/gallery/gallery-2.jpg')
    ),
    array(
        'title' => 'Sky Flower Market',
        'link' => '',       # leave empty to disable link
        'desc' => 'Lorem ipsum dolor sit amet, consectetur adipiscing elit. Morbi placerat lorem ac nibh pharetra pretium. Donec in tellus erat. Ut vestibulum nisi eu nisi auctor ullamcorper.',
        'img' => $this->themePath('includes/img/gallery/gallery-3.jpg')
    ),
    array(
        'title' => 'Bunch of Porings',
        'link' => 'https://www.ragnarealm-ro.net/main',
        'desc' => 'Lorem ipsum dolor sit amet, consectetur adipiscing elit. Morbi placerat lorem ac nibh pharetra pretium. Donec in tellus erat. Ut vestibulum nisi eu nisi auctor ullamcorper.',
        'img' => $this->themePath('includes/img/gallery/gallery-4.jpg')
    ),
);


# ==========================================================================================================
# [ragnarealm Footer Sections]
# ==========================================================================================================
# The text 'Powered by FluxCP' is removed from this template.
# The render text details is also removed froom this template.
#
# As for the theme settings, leave only 'ragnarealm' in [ThemeName], if you wish to disable the theme select option
# If you wish to leave the option to change theme to the users, make sure 'ragnarealm' is the first option, example
#
#       'ThemeName' => array('ragnarealm', 'default', 'bootstrap'),
#
# Note: Names of the themes you would like list for use in the footer. Themes are in FLUX_ROOT/themes.
#
# This option controls the links inside the footer.
$config['footer_discord']   = "https://discord.gg/ragnarealms/";
$config['footer_twitch']    = "https://twitch.com/";
$config['footer_facebook']  = "https://www.facebook.com/ragnarealms/";
$config['footer_twitter']   = "https://twitter.com/";
$config['footer_youtube']   = "https://www.youtube.com/";

$config['footer_links'] = array(
    'About RagnaRealm'      => "https://www.ragnarealms-ro.net",
    'Community'             => "https://www.google.com",
    'Forums'                => "https://www.ragnarealm-ro.net/forum",
    'Privacy Policy'        => "https://www.google.com",
    'Terms of Service'      => "https://www.google.com",
);

$config['footer_copyright_text'] = "All other copyrights and Trademarks are property of Gravity and their respective owners. <br />&copy;2023  Ragna Realms. All Rights Reserved.";

# Add the ID for the Wiget settings here
$config['wiget_discord_id']   = "1039662445007995031";
$config['wiget_discord_channel']   = "1039690363524362391";

?>